/*
 * Copyright (c) Dino Octavian.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution, and is available at
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * Contributors:
 *      Dino Octavian - initial API and implementation
 */
package gloodb;

import gloodb.GlooException;

/**
 * Exception thrown when trying to modify a locked object.
 */
public class LockingException extends GlooException {
    private static final long serialVersionUID = -7872115534107712493L;
    
    /**
     * Default constructor.
     */
    public LockingException() {
        super();
    }

    /**
     * Creates an exception object with a message.
     * @param message The message.
     */
    public LockingException(String message) {
        super(message);
    }
}
